require "selenium-webdriver"
require "rspec"
require "mongo"
require "./spec/spec_helper"
require_relative "../../pages/_config"
require "./pages/provider_login"
require "./pages/search"
include RSpec::Expectations


describe "Patient Search: PV-1439" do

  before(:all) do
    @driver = Selenium::WebDriver.for :firefox
    @base_url = $acp_url
    @wrapper_url = $acp_url + "/" + $acp_app
    @accept_next_alert = true
    @wait = Selenium::WebDriver::Wait.new(:timeout => 10)
    @driver.manage.timeouts.implicit_wait = 3
    @verification_errors = []

    #Remove last 20 history
    @db = Mongo::Connection.new("localhost", 27017).db("patient-search")
    @db.collection("selected-patients").remove()

    @login = ProviderLogin.new @driver
    @login.loginAsCprs1234()
            
    @driver.get(@wrapper_url)
    @search = Search.new(@driver)
  end
  
  after(:all) do
    @driver.quit
    @verification_errors.should == []
  end
  
  before(:each) do
    @driver.get(@wrapper_url)
  end
  
  describe "Last 20 selected patients: PV-117" do
    
    it 'should display Last 20 in the search popup' do
      @search.openSearchMenu()
      @search.selectLast20()
      expect(@search.getSearchHeader()).to eq('Last 20 Patients')
    end

    it 'should display only selected patients: PV-286' do
      #@db.collection("selected-patients").remove()

      @search.updatePatientContextByName("fiftyfive, patient")
      @search.updatePatientContextByName("onehundredeleven, patient")

      @search.openSearchMenu()
      @search.selectLast20
      expect(@search.hasPatient('FIFTYFIVE, PATIENT'))
      expect(! @search.hasPatient('ONEHUNDREDELEVEN, PATIENT'))
    end
    
    it 'should not list duplicate patients' do
      @db.collection("selected-patients").remove()
      sleep(3)

      @search.updatePatientContextByName("eleven, patient")
      @search.updatePatientContextByName("sixtysix, patient")
      @search.updatePatientContextByName("eleven, patient")

      @search.openSearchMenu()
      @search.selectLast20

      expect(@search.getSearchResultsLength() === 2)
      expect(@search.getPatientNameAtRow(1) == 'ELEVEN, PATIENT')
      expect(@search.getPatientNameAtRow(2) == 'SIXTYSIX, PATIENT')
    end

#    #Numeric patients no longer exist so this was re-written below with a static list of patients.
#    it 'should display a max of 20 patients' do
#      #Populate list of last 20
#      (47..68).each do |i|
#        if(i == 59 || i == 62) #workaround for data issues with patient59 and 62
#          @search.updatePatientContextByName("patient01")
#          @search.updatePatientContextByNameAtRow(2)
#          sleep(2)
#        end
#        @search.updatePatientContextByName("patient" + i.to_s)
#        sleep(1)
#        @search.updatePatientContextByNameAtRow(2)
#        sleep(4)
#      end
#      
#      @search.openSearchMenu()
#      @search.selectLast20
#      expect(@search.getPatientNameAtRow(1)).to eq("patient68, zztest")
#      expect(@search.getSearchResultsLength()).to eq(20)
#    end
    
    it 'should display a max of 20 patients' do
      #@db.collection("selected-patients").remove()

      @search.updatePatientContextByName("fourhundredone, patient")
      @search.updatePatientContextByName("fourhundredtwo, patient")
      @search.updatePatientContextByName("fourhundredthree, patient")
      @search.updatePatientContextByName("fourhundredfour, patient")
      @search.updatePatientContextByName("fourhundredfive, patient")
      @search.updatePatientContextByName("fourhundredsix, patient")
      @search.updatePatientContextByName("fourhundredseven, patient")
      @search.updatePatientContextByName("fourhundredeight, patient")
      @search.updatePatientContextByName("fourhundrednine, patient")
      @search.updatePatientContextByName("fourhundredten, patient")
      @search.updatePatientContextByName("fourhundredeleven, patient")
      @search.updatePatientContextByName("fourhundredtwelve, patient")
      @search.updatePatientContextByName("fourhundredthirteen, patient")
      @search.updatePatientContextByName("fourhundredfourteen, patient")
      @search.updatePatientContextByName("fourhundredfifteen, patient")
      @search.updatePatientContextByName("fourhundredsixteen, patient")
      @search.updatePatientContextByName("fourhundredseventeen, patient")
      @search.updatePatientContextByName("fourhundredeighteen, patient")
      @search.updatePatientContextByName("fourhundrednineteen, patient")
      @search.updatePatientContextByName("fourhundredtwenty, patient")
      @search.updatePatientContextByName("fourhundredtwentyone, patient")

      @search.openSearchMenu()
      @search.selectLast20
      expect(@search.getPatientNameAtRow(1) == "FOURHUNDREDTWENTYONE, PATIENT")
      expect(@search.getPatientNameAtRow(20) == "FOURHUNDREDTWENTYTWO, PATIENT")
      # Only 20 searches should be visible
      expect(@search.getSearchResultsLength() === 20)
      # First patient search of 21 should no longer be visible
      expect(! @search.hasPatient('FOURHUNDREDONE, PATIENT'))        
    end 
        
  end #close last 20 describe block
  
end  